title "Women's labour-force participation, Canada 1977";
/*
Source: Social Change in Canada Project, York Institute for
Social Research.
*/

%include catdata(wlfpart);
options formchar="|----|+|---+=|-/\<>*";

proc logistic data=wlfpart nosimple descending;
   model labor  = husinc children ;
   title2 'Proportional Odds Model for Fulltime/Parttime/NotWorking';
run;

proc logistic data=wlfpart nosimple descending;
   model working = husinc children ;
   output out=resultw p=predict;
   ods output GlobalTests=gtests1;
   title 'Nested Dichotomies';
proc plot;
   plot predict * husinc = children;

proc logistic data=wlfpart nosimple descending;
   model fulltime = husinc children ;
   output out=resultf p=predict;
   ods output GlobalTests=gtests2;
proc plot;
   plot predict * husinc = children;
run;
quit;

title2 'Summing Global tests for full 3-category model';
data gtests;
	set gtests1 gtests2;
	by Test;
proc print data=gtests;
	by Test;
	id Test;
	sum ChiSq df;
	run;

