%include catdata(wlfpart);
options formchar="|----|+|---+=|-/\<>*";

proc format;
   value labor    /* labor-force participation */
      1 ='Full-time'
      2 ='Part-time'
      3 ='Not working';

*-- Fit generalized logit model;
proc logistic data=wlfpart;
   model labor = husinc children / link=glogit;
   output out=results p=predict xbeta=logit;

data results;
	set results;
	drop r1-r4 region fulltime working;
	label predict='Fitted probability';
  format children kids.;

proc sort data=results;
	by children husinc _level_;

*-- simple plot;
proc plot data=results;
	plot predict * husinc = _level_ ;
	by children;
 

*-- Curve labels;
%label(data=results, x=husinc, y=predict, cvar=_level_,
	by=children, subset=last._level_, text=put(_level_, labor.), 
	pos=2, out=labels1);
	
*-- Panel labels;
%label(data=results, x=20, y=0.85, 
	by=children, subset=last.children, text=put(children, kids.), 
	pos=2, size=2, out=labels2);
data labels;
	set labels1 labels2;
	by children;
	
title;
goptions hby=0;
proc gplot data=results;
	plot predict * husinc = _level_ / 
		vaxis=axis1 hm=1 vm=1 anno=labels nolegend;
	by children;
	axis1 order=(0 to .9 by .1) label=(a=90);
	symbol1 i=join v=circle   c=black;
	symbol2 i=join v=square   c=red;
	symbol3 i=join v=triangle c=blue;
	run;

