%include catdata(vision);

data women;
	set women;
	if left=right then do;
		diag=left;
		symmetry=-left;
		end;
	else do;
		diag=0;
		symmetry = abs(left-right);
		end;
proc print;
	run;

title 'Independence model (women)';
proc genmod data=women;
	class Right Left;
	model Count = Left Right /
		dist=poisson link=log obstats residuals type3
		;
  ods exclude obstats;
  ods output obstats=obstats;
run;
%mosaic(data=obstats, vorder=Right Left, split=H V, htext=1.9,
	resid=reschi, title=%str(Independence, G2(9)=6671.5));

title 'Quasi-independence model (women)';
proc genmod data=women;
	class Right Left diag;
	model Count = Left Right diag /
		dist=poisson link=log obstats residuals type3
		;
  ods exclude obstats;
  ods output obstats=obstats;
run;
%mosaic(data=obstats, vorder=Right Left, split=H V, htext=1.9,
	resid=reschi, title=%str(Quasi-Independence, G2(5)=199.1));

title 'Symmetry model (women)';
proc genmod data=women;
	class Left Right symmetry;
	model Count = symmetry /
		dist=poisson link=log obstats residuals type3
		;
  ods exclude obstats;
  ods output obstats=obstats;
run;
%mosaic(data=obstats, vorder=Right Left, split=H V, htext=1.9,
	resid=reschi, title=%str(Symmetry, G2(6)=19.25));


title 'Quasi-Symmetry model (women)';
proc genmod data=women;
	class Right Left symmetry;
	model Count = Left Right symmetry /
		dist=poisson link=log obstats residuals type3
		;
  ods exclude obstats;
  ods output obstats=obstats;
run;

%mosaic(data=obstats, vorder=Right Left, split=H V, htext=1.9,
	resid=reschi, title=%str(Quasi-Symmetry, G2(3)=7.27));

*-- How to test for marginal homogeneity;
proc catmod data=women;
	weight count;
	response marginals;
	model right*left=_response_ / freq;
	repeated side 2;
	title 'Test of Marginal Homogeneity';
quit;
