*-- SAS 9.3 ---;
%include catdata(msdiag);

*-- Agreement, separately, and controlling for Patients;
proc freq data=msdiag;
     tables patients * N_rating * W_rating / norow nocol nopct agree plots=all;
     test kappa;
     weight count;
run;

*-- Using Fleiss-Cohen weights;
proc freq data=msdiag;
     tables patients * N_rating * W_rating / norow nocol nopct agree(wt=FC);
     test kappa;
     weight count;
run;
data Winnipeg;
   set msdiag;
   where (patients="Winnipeg");
%agreeplot(data=Winnipeg, var=N_rating W_rating, title=Winnipeg patients);

data NewOrleans;
   set msdiag;
   where (patients="New Orleans");
%agreeplot(data=NewOrleans, var=N_rating W_rating, title=New Orleans patients);
