*newsas(mentgen2);
%include goptions;
goptions hsize=6.5in vsize=6.5in;
%include catdata(mental);


*-- Create numeric variables for row & column effects;
data mental;
   set mental;
   m_lin = mental;
   s_lin = ses;
   format mental mental. ses ses.;


proc genmod data=mental;
   class mental ses;
   model count = mental ses / dist=poisson obstats residuals;
   title 'Independence';
   ods output obstats=obstats;
%mosaic(data=obstats, vorder=Mental SES, resid=stresdev, 
	title=Mental Impairment and SES: Independence, split=H V, 
	cellfill=dev 0.5, htext=2.0);


proc genmod data=mental;
   class mental ses;
   model count = mental ses mental*s_lin / dist=poisson obstats residuals;
   title 'Row Effects, Linear SES';
   ods output obstats=obstats;

%mosaic(data=obstats, vorder=Mental SES, resid=stresdev, 
	title=Row Effects: Mental * Linear SES, split=H V, 
	cellfill=dev 0.5, htext=2.0);

proc genmod data=mental;
   class mental ses;
   model count = mental ses m_lin*s_lin / dist=poisson obstats residuals;
   title 'Lin x Lin';
   ods output obstats=obstats;
run;
%mosaic(data=obstats, vorder=Mental SES, resid=stresdev, 
	title=Linear x Linear, split=H V, cellfill=dev 0.5, htext=2.0);
