%include catdata(mental);

*-- Apply formats for descriptive labels;
data mental;
	set mental;
	format mental mental. ses ses.;
run;
	
*-- Using the corresp macro;
%corresp(data=mental, 
	tables = mental / ses,
	weight = count,
	htext=1.3);

*-- Using ODS Graphics;
*-- SAS 9.3: plots are automatic;
*ods html file="mental-ca.html";
*ods graphics on;

proc corresp short data=mental;
	tables mental, ses;
	weight count;
	run;

*ods graphics off;
*ods html close;
