%include catdata(cowles);

data cowles;
	set cowles;
	format Sex sex. Volunteer volun.;
proc print data=cowles(obs=20);
	run;
	
*-- main effects model;
proc logistic data=cowles outest=parm  descending ;
    class Sex;
	model Volunteer = Sex Extraver  Neurot /  lackfit ;
	run;
	
*-- all two-way model;
proc logistic data=cowles outest=parm  descending ;
    class Sex;
	model Volunteer = Sex | Extraver | Neurot @2 /lackfit ;
	run;

*-- reduced model;
proc logistic data=cowles outest=parm  descending ;
    class Sex;
	model Volunteer = Sex   Extraver | Neurot / lackfit ;
	run;
