*-- SAS 9.3 ---;
%include catdata(cowles);

data cowles;
	set cowles;
	format Sex sex. Volunteer volun.;
proc print data=cowles(obs=20);
	run;


*-- interaction model, with effect plots;
proc logistic data=cowles outest=parm  descending ;
    class Sex;
	model Volunteer = Sex   Extraver | Neurot / lackfit ;
	effectplot slicefit(x=Extraver sliceby=Neurot) / at(sex=1.5) noobs;
	effectplot slicefit(x=Neurot sliceby=Extraver) / at(sex=1.5) noobs;
	effectplot contour(x=Neurot y=Extraver) / at(sex=1.5) noobs;
	run;

