%include catdata(berkeley);
title h=1.8 'Berkeley Admissions Data';
goptions vsize=6.2 in hsize=7 in  htext=1.6;

data berkeley;
   set berkeley;
   dept1AG = (gender='F') *  (dept=1);
   format dept dept.;

proc catmod order=data
            data=berkeley;
   format dept dept. ;
   population dept gender;
   weight freq;
   response / out=predict;
   model admit = dept  / ml noiter noprofile title="Model (AD, DG)";
run;
 
title 'Model:  logit(Admit) = Dept'
		      a=-90 'Probability (Admitted)'
      h=3 a=-90 ' ';
legend1 position=(bottom inside left)  offset=(4,3)
        mode=share cborder=blue
        across=1
        shape=symbol(6,1.5)
        label=('Gender')
        value=(c=black 'Female'
               c=red   'Male');
axis1 order=(-3 to 2) offset=(4)
      label=(a=90 'Log Odds (Admitted)');
axis2 label=('Department') offset=(4);
%pscale(lo=-4, hi=3, anno=pscale, prob=%str(0.05,.1,.25,.5,.75,.9));
%catplot(data=predict, class=gender, x=dept, z=1.96, type=FUNCTION,
         legend=legend1, anno=pscale);
*gskip;
 
proc catmod order=data
            data=berkeley;
   format dept dept. ;
   weight freq;
   response / out=predict;
   model admit = dept gender / ml noiter noprofile title="Model (AD, AG, DG)" ;
  run;
 
%pscale(lo=-4, hi=3, anno=pscale, prob=%str(0.05,.1,.25,.5,.75,.9));

title 'Model:  logit(Admit) = Dept Gender'
		      a=-90 'Probability (Admitted)'
      h=3 a=-90 ' ';
legend1 position=(bottom inside left)  offset=(4,3)
        mode=share cborder=blue across=1
        shape=symbol(6,1.5) label=('Gender')
        value=(c=black 'Female'
               c=red   'Male');
axis1 order=(-3 to 2) offset=(4)
      label=(a=90 'Log Odds (Admitted)');
axis2 label=('Department') offset=(4);
symbol1 i=none v=circle h=1.8 c=black;
symbol2 i=none v=dot    h=1.8 c=red  ;
%catplot(data=predict, class=gender, x=dept, type=FUNCTION,
	z=1.96, anno=pscale, legend=legend1);

