*newsas(genberk2);
title 'Berkeley Admissions data';
%include catdata(berkeley);
*include goptions;

*-- Apply formats to use value labels for numeric variables; 
data berkeley;
   set berkeley;
   format dept dept. admit admit. gender $sex.;

*-- Fit model of homogeneous associations:  [AD][GD][AG];
title 'Homogeneous associations:  [AD][GD][AG]';
proc genmod data=berkeley;
   class dept gender admit;
   model freq = dept|gender|admit@2 / dist=poisson type3 wald;
run;

*-- Fit model of conditional independence:  [AD][GD];
title 'Conditional independence:  [AD][GD]';
proc genmod data=berkeley;
   class dept gender admit;
   model freq = dept|gender dept|admit / dist=poisson obstats;
   ods output obstats=obstats;
   ods exclude obstats;
run;

%mosaic(data=obstats, vorder=admit gender dept, count=freq,
        resid=streschi, cellfill=dev, split=H V,
        title=Model: [AdmitDept] [GenderDept]);

*-- Conditional independence, except for an [AG] term in Dept A;
title 'Conditional independence, ignoring Dept A';
data berkeley;
   set berkeley;
   dept1AG = (gender='F') * admit * (dept=1);

proc genmod data=berkeley;
   class dept gender admit;
   model freq = dept|gender dept|admit dept1AG / dist=poisson obstats type3;
   ods output obstats=obstats;
   ods exclude obstats;
run;

%mosaic(data=obstats, var=admit gender dept, vorder=admit gender dept, count=freq,
        resid=streschi, cellfill=dev, split=H V,
        title=Model: [AdmitDept] [GenderDept] [Dept1AG]);

