*goptions vsize=6.5in hsize=7in htext=1.8;


title 'Berkeley Admissions data: diagnostic plots';

%include catdata(berkeley);

*-- make a cell ID variable, joining factors;
data berkeley;
   set berkeley;
   cell = trim(put(dept,dept.)) ||
          gender ||
          trim(put(admit,yn.));
run;

*-- Conditional independence;
proc genmod data=berkeley;
   class dept gender admit;
   model freq = dept|gender dept|admit / dist=poisson obstats residuals;
   ods output obstats=obstats;

%inflglim(data=berkeley, class=dept gender admit,
        resp=freq, model=dept|gender dept|admit, dist=poisson, id=cell,
        gx=hat, gy=stresdev);

%inflglim(data=berkeley, class=dept gender admit,
        resp=freq, model=dept|gender dept|admit, dist=poisson, id=cell,
        gx=hat, gy=difdev);

%halfnorm(data=berkeley, class=dept gender admit,
   resp=freq, model=dept|gender dept|admit, dist=poisson, id=cell);
