*-- SAS 9.3 ---;
title 'Logistic regression ODS plots (proportional odds model)';
%include catdata(arthrit);

*ods graphics on /reset imagename='arthritis-propodds-ods' width=5in height=4in noborder;
*ods select EffectPlot ORPlot (persist);
proc logistic data=arthrit descending  ;
   class sex (ref=last) treat (ref=first) / param=ref;
   model  improve = sex  treat  age / clodds=wald expb;
   effectplot slicefit(sliceby=improve plotby=Treat) / at(sex=all) clm alpha=0.33 ;
   effectplot interaction(x=Treat sliceby=improve) / at(sex=all) noobs clm alpha=0.33;
run;
*ods graphics off;
