%include catdata(arthrit);
options formchar="|----|+|---+=|-/\<>*";

*-- simple logistic regression on age;
title 'Simple logistic regression on age';
proc logistic data=arthrit descending;
   model  better = age ;
   output out=results0 p=prob l=lower u=upper / alpha=.33;

*-- simple plot of predicted probabilities +- 1 SE;
proc plot data=results0;
   plot better * age = sex
        prob   * age = '@'
        lower  * age = 'v'
        upper  * age = '^' / overlay;
	run;

*-- fancier hi-res plot;
proc sort data=results0;
	by age;
%points(data=results0, x=Age, y=better, out=points);
proc gplot data=results0;
   plot 
        prob   * age = 1
        lower  * age = 2
        upper  * age = 3 / overlay vaxis=axis1 anno=points;
   symbol1 v=none c=black i=join;
   symbol2 v=none c=blue i=join l=3;
   symbol3 v=none i=join c=blue l=3;
   axis1 label=(a=90) order=(0 to 1 by .2);
	run;


	
title 'main effects model';
proc logistic data=arthrit descending;
   class sex (ref=last) treat (ref=first) / param=ref;
   model  better = sex  treat  age ;
   output out=results p=prob l=lower u=upper
          xbeta=logit stdxbeta=selogit / alpha=.33;
	run;

*-- plot, with GPLOT;
proc sort data=results;
	by sex treat age;

proc gplot data=results;
	plot prob * age = treat / vaxis=axis1;
	by sex;
	symbol1 v=circle i=join l=3 c=blue;
	symbol2 v=dot    i=join l=1 c=red;
	run;

*-- or use meanplot macro;
%meanplot(data=results, response=prob, class=age treat sex, pmean=no);


title 'screening for higher-order effects';
proc logistic data=arthrit descending;
   class sex(ref=last) treat(ref=first) / param=ref;
   model  better = age sex treat
                   age | sex | treat @2  age*age
                   / selection=forward
                     slentry=0.1   /* be a bit liberal */
                     start=3 ;     /* Start after all main effects */
   title2 'Testing all interactions via forward selection';
	run;
