%include catdata(arthrit);

*-- simple logistic regression on age;
title 'Simple logistic regression on age';
proc logistic data=arthrit descending;
   model  better = age ;
   effectplot fit / obs(jitter(y=0.02));
   effectplot fit / obs(jitter(y=0.02)) link;  * display on logit scale;
run;

	
title 'main effects model';
proc logistic data=arthrit descending;
   class sex (ref=last) treat (ref=first) / param=ref;
   model  better = sex  treat  age ;
   output out=results p=prob l=lower u=upper
          xbeta=logit stdxbeta=selogit / alpha=.33;
   effectplot slicefit (sliceby=treat) / at(sex=all) clm alpha=0.33;
   effectplot interaction (x=treat sliceby=sex) / at(age=30 60) clm alpha=0.33 noobs;
	run;
*-- or use meanplot macro;
%meanplot(data=results, response=prob, class=age treat sex, pmean=no);


title 'screening for higher-order effects';
proc logistic data=arthrit descending;
   class sex(ref=last) treat(ref=first) / param=ref;
   model  better = age sex treat
                   age | sex | treat @2  age*age
                   / selection=forward
                     slentry=0.1   /* be a bit liberal */
                     start=3 ;     /* Start after all main effects */
   effectplot slicefit (sliceby=treat) / at(sex=all)clm alpha=0.33;
   title2 'Testing all interactions via forward selection';
	run;
