*-- SAS 9.3 ---;
title 'Logistic regression ODS plots';
%include catdata(arthrit);

*ods graphics on /reset imagename='arthritis-logistic-ods' width=4.5in height=4in noborder;
*ods select EffectPlot ORPlot (persist);
title 'Arthritis data: effect plots';
proc logistic data=arthrit descending 
         plots(only)=(effect(plotby=sex sliceby=treat showobs clband alpha=0.33));
   class sex (ref=last) treat (ref=first) / param=ref;
   model  better = sex  treat  age / clodds=wald;
   effectplot / at(Sex=all)  clm alpha=0.33;
   effectplot slicefit(sliceby=Sex plotby=Treat) /clm alpha=0.33 ;
   effectplot interaction(x=Treat sliceby=Sex) / noobs clm alpha=0.33;
	run;
*ods graphics off;
