*-- SAS 9.3 ---;
%include catdata(arrests);

*-- main effects model;
proc logistic data=arrests descending;
	class colour year sex citizen employed;
	model released = colour year age sex employed citizen checks;
	effectplot interaction (x=year sliceby=colour) / clm alpha=0.33 noobs yrange=clip;
	run;

*-- all two-way model;
proc logistic data=arrests descending;
	class colour year sex citizen employed;
	model released = colour | year | age | sex | employed | citizen | checks@2;
	effectplot interaction (x=year sliceby=colour) / clm alpha=0.33 noobs yrange=clip;
	effectplot slicefit (x=age sliceby=colour) / clm alpha=0.33 obs(fringe jitter) yrange=(.7, 1);
	run;

*-- demonstrate using forward selection to examine interactions;
proc logistic data=arrests descending;
	class colour year sex citizen employed;
	model released = 
			colour   year   age   sex   employed   citizen   checks    
			colour | year | age | sex | employed | citizen | checks@2 
	      /start=7 selection=forward;
	run;

*-- simplified model;
proc logistic data=arrests descending;
	class colour year sex citizen employed;
	model released = 
			colour|year colour|age   sex   employed   citizen   checks / clodds=wald;
	effectplot interaction (x=year sliceby=colour) / clm alpha=0.33 noobs yrange=clip;
	effectplot slicefit (x=age sliceby=colour) / clm alpha=0.33 obs(fringe jitter) yrange=(.7, 1);
	run;

