library(vcd)
data("UCBAdmissions")

# rearrange dimensions 
UCB <- aperm(UCBAdmissions, c(2,1,3))
# marginal table, collapsing over Dept
fourfold(margin.table(UCB, c(1,2)))

# 3-way table, stratified by Dept
fourfold(UCB, mfrow=c(2,3))

# test homogeneity of odds ratios over Dept
woolf_test(UCB)

# calculate odds ratios
oddsratio(UCBAdmissions, log=FALSE)
# plot log odds ratios
plot(oddsratio(UCBAdmissions), xlab="Department", ylab="Log Odds Ratio (Admit|Gender)")
