# Examples from John Fox's JSS paper

library(effects)    # for Arrests data
library(car)        # for Anova()
data(Arrests)
Arrests$year <- as.factor(Arrests$year)

arrests.mod <- glm(released ~ employed + citizen + checks
 + colour*year + colour*age,
 family=binomial, data=Arrests)

Anova(arrests.mod)

# Plot 3-way effect (not in model)
plot(effect("colour:year:age", arrests.mod, xlevels=list(age=15:45)),
  multiline=TRUE, ylab="Probability(released)", rug=FALSE)

# colour x year interaction
plot(effect("colour:year", arrests.mod),
      multiline=TRUE, ylab="Probability(released)")

# colour x age interaction
plot(effect("colour:age", arrests.mod),
      multiline=FALSE, ylab="Probability(released)")

# interactive call, allowing you to select plots from a menu
arrests.effects <- allEffects(arrests.mod, xlevels=list(age=seq(15,45,5)))
plot(arrests.effects, ylab="Probability(released)")
     